require( "quest/mg_flower/convout.lua" );
combine_speech_tables();

round_num = 
{
	6, -- round one	
};

local option1 = false;

initial_setup = true;
show_activity_text = false;
passed_activity = false;

-- When art asset size is doubled, halve each of these values;
local flowerScaleActive = 1.3;
local flowerScaleInactive = 1;

local vaseOffset = { x = -23, y = 0 };
local bouquetOffset = { x = 0, y = 0 };
local ovalOffset = { x = 380, y = 0 };
local flowerCounts = { 0, 0, 0, 0 };
local flowerLayer = 10;
local checkBouquetOffset = { x = 505, y = 420 };
local constraintsOffset = { x = 62, y = 200 };
local flowerRegOffset = { x = 25, y = 60 };

local placedFlowers = { nil, nil, nil, nil, nil, nil, nil, nil, nil };
local results = { nil, nil, nil, nil, nil, nil };
local flowersPlaced = 0;
local totalFlowers = 0;
local currentFlower = nil;
local checkBouquet = nil;
local currentConstraints = nil;
local constraintsActor = nil;

local otherStuffToBeExpired = { };
local stuffToMove = { };
local startPositions = { };

local resultsPos = { x = 25, y = 230 };
local resultsOffset = { x = 0, y = 36 };

local resultOffsets =
{
	{ x= resultsPos.x + (resultsOffset.x * 0), y = resultsPos.y + (resultsOffset.y * 0) },
	{ x= resultsPos.x + (resultsOffset.x * 1), y = resultsPos.y + (resultsOffset.y * 1) },
	{ x= resultsPos.x + (resultsOffset.x * 2), y = resultsPos.y + (resultsOffset.y * 2) },
	{ x= resultsPos.x + (resultsOffset.x * 3), y = resultsPos.y + (resultsOffset.y * 3) },
	{ x= resultsPos.x + (resultsOffset.x * 4), y = resultsPos.y + (resultsOffset.y * 4) },
	{ x= resultsPos.x + (resultsOffset.x * 5), y = resultsPos.y + (resultsOffset.y * 5) }
}

local colours =
{
	red = { r = 1, g = 0, b = 0, a = 1 },
	pink = { r = 1, g = 0.5, b = 0.5, a = 1 },
	orange = { r = 1, g = 0.5, b = 0, a = 1 },
	yellow = { r = 1, g = 1, b = 0, a = 1 },
	blue = { r = 0, g = 0, b = 1, a = 1 },
	purple = { r = 1, g = 0, b = 1, a = 1 },	
};

local neighbourList = 
{
	{ 2, 3 },
	{ 1, 3, 4, 5 },
	{ 1, 2, 5, 6 },
	{ 2, 5, 7 },
	{ 2, 3, 4, 6, 7, 8 },
	{ 3, 5, 8 },
	{ 4, 5, 8, 9 },
	{ 5, 6, 7, 9 },
	{7, 8 }
}

local items = 
{
	-- level 1
	{
		constraints = 
		{
			differentColours = 4,
			typeCompare = { "daisy", "rose", 0 }, -- { first type, second type, comparison (1 = more, 0 = equal, -1 = less) }, nil = no restriction
			noTouchColour = { "pink", "blue" }			
		};
		ovals = { 2, 3, 4, 5, 6, 7, 8 };	
		flowers = 
		{
			{ flowerType = "rose", colour = "red" },
			{ flowerType = "rose", colour = "pink" },
			{ flowerType = "rose", colour = "blue" },
			{ flowerType = "rose", colour = "yellow" },
			{ flowerType = "tulip", colour = "red" },
			{ flowerType = "tulip", colour = "pink" },
			{ flowerType = "tulip", colour = "blue" },
			{ flowerType = "tulip", colour = "yellow" },
			{ flowerType = "daisy", colour = "blue" },
			{ flowerType = "daisy", colour = "pink" },

		};
	};	
	-- level 2
	{
		constraints = 
		{
			typeCompare = { "daisy", "tulip", 1 }, -- { first type, second type, comparison (1 = more, 0 = equal, -1 = less) }, nil = no restriction
			colourCompare = { "yellow", "orange", 0 },
			colourMiddle = { "purple", 1 },						
			noTouchColour = { "purple", "orange" }
		};
		ovals = { 1, 2, 3, 5, 7, 8, 9 };	
		flowers = 
		{
			{ flowerType = "lily", colour = "purple" },
			{ flowerType = "lily", colour = "blue" },
			{ flowerType = "lily", colour = "orange" },
			{ flowerType = "lily", colour = "yellow" },
			{ flowerType = "tulip", colour = "purple" },
			{ flowerType = "tulip", colour = "blue" },
			{ flowerType = "tulip", colour = "orange" },
			{ flowerType = "daisy", colour = "purple" },
			{ flowerType = "daisy", colour = "orange" },
			{ flowerType = "daisy", colour = "yellow" },
		};
	};	
	-- level 3
	{
		constraints = 
		{
			differentTypes = 3,
			colourCompare = { "blue", "yellow", 1 },						
			typeMiddle = { "tulip", 1 },
			noTouchColour = { "blue", "yellow" }
		};
		ovals = { 2, 3, 4, 5, 6, 7, 8 };	
		flowers = 
		{
			{ flowerType = "rose", colour = "red" },
			{ flowerType = "rose", colour = "yellow" },
			{ flowerType = "rose", colour = "blue" },
			{ flowerType = "daisy", colour = "yellow" },
			{ flowerType = "daisy", colour = "red" },
			{ flowerType = "tulip", colour = "blue" },
			{ flowerType = "tulip", colour = "pink" },
			{ flowerType = "tulip", colour = "yellow" },
			{ flowerType = "daisy", colour = "pink" },
			{ flowerType = "daisy", colour = "blue" },
		};
	};	
	-- level 4
	{
		constraints = 
		{
			differentColours = 5,
			colourCompare = { "red", "pink", 0 }, -- { first type, second type, comparison (1 = more, 0 = equal, -1 = less) }, nil = no restriction
			typeRow = { "tulip", 1, 1 }, -- last index = 1 for in, -1 for not in
			typeMiddle = { "rose", 1 },
			noTouchType = { "rose", "tulip" }
		};
		ovals = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };	
		flowers = 
		{
			{ flowerType = "tulip", colour = "red" },
			{ flowerType = "tulip", colour = "pink" },
			{ flowerType = "tulip", colour = "purple" },
			{ flowerType = "tulip", colour = "blue" },
			{ flowerType = "tulip", colour = "yellow" },
			{ flowerType = "rose", colour = "red" },
			{ flowerType = "rose", colour = "pink" },
			{ flowerType = "rose", colour = "purple" },
			{ flowerType = "rose", colour = "blue" },
			{ flowerType = "daisy", colour = "blue" },
		};
	};	
	-- level 5
	{
		constraints = 
		{
			differentColours = 4,
			typeRow = { "daisy", 2, 1 },
			colourMiddle = { "red", 1 },
			noTouchType = { "tulip", "daisy" },
			noTouchColour = { "blue", "red" }
		};
		ovals = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };	
		flowers = 
		{
			{ flowerType = "rose", colour = "red" },
			{ flowerType = "rose", colour = "blue" },
			{ flowerType = "rose", colour = "yellow" },
			{ flowerType = "lily", colour = "red" },
			{ flowerType = "lily", colour = "blue" },
			{ flowerType = "daisy", colour = "red" },
			{ flowerType = "daisy", colour = "blue" },
			{ flowerType = "tulip", colour = "yellow" },
			{ flowerType = "tulip", colour = "red" },
			{ flowerType = "tulip", colour = "pink" },


		};
	};	
	-- level 6
	{
		constraints = 
		{
			differentColours = 5,	
			typeCompare = { "daisy", "tulip", 1 }, -- { first type, second type, comparison (1 = more, 0 = equal, -1 = less) }, nil = no restriction
			colourCompare = { "red", "purple", 0 },						
			typeMiddle = { "tulip", 1 },
			noTouchType = { "tulip", "daisy" },
			noTouchColour = { "purple", "red" }			
		};
		ovals = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };	
		flowers = 
		{
			{ flowerType = "rose", colour = "red" },
			{ flowerType = "tulip", colour = "red" },
			{ flowerType = "daisy", colour = "yellow" },
			{ flowerType = "tulip", colour = "blue" },
			{ flowerType = "daisy", colour = "blue" },
			{ flowerType = "daisy", colour = "purple" },
			{ flowerType = "tulip", colour = "purple" },
			{ flowerType = "lily", colour = "pink" },
			{ flowerType = "daisy", colour = "pink" },
			{ flowerType = "tulip", colour = "pink" },
		};		
	};	
};

stringToIndex = 
{
	red = 1,
	pink = 2,
	orange = 3,
	yellow = 4,
	blue = 5,
	purple = 6,
	rose = 1,
	tulip = 2,
	daisy = 3,
	lily = 4
}

local flowers = 
{
	{ position = { x = 70, y = 70 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 130, y = 70 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 190, y = 70 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 250, y = 70 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 310, y = 70 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 70, y = 145 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 130, y = 145 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 190, y = 145 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 250, y = 145 }, placement_offset = { x = 56, y = 42 } },
	{ position = { x = 310, y = 145 }, placement_offset = { x = 56, y = 42 } }
};

local OvalInfo = 
{
	{ position = { x = 170, y = 40 }, depth = 3 },
	{ position = { x = 125, y = 95 }, depth = 4 },
	{ position = { x = 215, y = 95 }, depth = 4 },
	{ position = { x = 80, y = 150 }, depth = 5 },
	{ position = { x = 170, y = 150 }, depth = 5 },
	{ position = { x = 260, y = 150 }, depth = 5 },
	{ position = { x = 125, y = 205 }, depth = 6 },
	{ position = { x = 215, y = 205 }, depth = 6 },
	{ position = { x = 170, y = 260 }, depth = 7 }
};

local rowFromIndex = { 1, 2, 2, 3, 3, 3, 4, 4, 5 };

function CheckConstraints()
	local numColours = 
	{ 
		{ colours = { 0, 0, 0, 0, 0, 0 }, types = { 0, 0, 0, 0 } },
		{ colours = { 0, 0, 0, 0, 0, 0 }, types = { 0, 0, 0, 0 } },
		{ colours = { 0, 0, 0, 0, 0, 0 }, types = { 0, 0, 0, 0 } },
		{ colours = { 0, 0, 0, 0, 0, 0 }, types = { 0, 0, 0, 0 } },
		{ colours = { 0, 0, 0, 0, 0, 0 }, types = { 0, 0, 0, 0 } },
		colours = { 0, 0, 0, 0, 0, 0 },
		types = { 0, 0, 0, 0, 0, 0 }
	};
		
	for i,v in pairs(placedFlowers) do
		if ( placedFlowers[i] ~= nil ) then			
			numColours[rowFromIndex[i]].colours[stringToIndex[placedFlowers[i].colour]] = numColours[rowFromIndex[i]].colours[stringToIndex[placedFlowers[i].colour]] + 1;
			numColours[rowFromIndex[i]].types[stringToIndex[placedFlowers[i].flowerType]] = numColours[rowFromIndex[i]].types[stringToIndex[placedFlowers[i].flowerType]] + 1;
			numColours["colours"][stringToIndex[placedFlowers[i].colour]] = numColours["colours"][stringToIndex[placedFlowers[i].colour]] + 1;
			numColours["types"][stringToIndex[placedFlowers[i].flowerType]] = numColours["types"][stringToIndex[placedFlowers[i].flowerType]] + 1;
		end
	end

	-- calculate the number of different colours and types used
	local numDifferentColours = 0;
	local numDifferentTypes = 0;
	for i = 1, 6 do		
		if ( numColours["colours"][i] > 0 ) then
			numDifferentColours = numDifferentColours + 1;			
		end
		if ( numColours["types"][i] > 0 ) then
			numDifferentTypes = numDifferentTypes + 1;			
		end
	end
	
	--  Check each constraint for pass(1), fail(-1) or n/a(0)
	local constraints = { 0, 0, 0, 0, 0, 0, 0, 0 ,0 ,0 };
	if ( currentConstraints.differentTypes ~= nil ) then
		if ( numDifferentTypes >= currentConstraints.differentTypes ) then
			constraints[1] = 1;
		else
			constraints[1] = -1;
		end
	end
	if ( currentConstraints.differentColours ~= nil ) then
		if ( numDifferentColours >= currentConstraints.differentColours ) then
			constraints[2] = 1;
		else
			constraints[2] = -1;
		end
	end
	if ( currentConstraints.typeCompare ~= nil ) then
		local passed = -1;
		if ( currentConstraints.typeCompare[3] == 1 ) then
			if ( numColours["types"][stringToIndex[currentConstraints.typeCompare[1]]] > numColours["types"][stringToIndex[currentConstraints.typeCompare[2]]] ) then
				passed = 1;
			end
		elseif ( currentConstraints.typeCompare[3] == 0 ) then
			if ( numColours["types"][stringToIndex[currentConstraints.typeCompare[1]]] == numColours["types"][stringToIndex[currentConstraints.typeCompare[2]]] ) then
				passed = 1;
			end
		elseif ( currentConstraints.typeCompare[3] == -1 ) then
			if ( numColours["types"][stringToIndex[currentConstraints.typeCompare[1]]] < numColours["types"][stringToIndex[currentConstraints.typeCompare[2]]] ) then
				passed = 1;
			end
		end
		constraints[3] = passed;		
	end
	if ( currentConstraints.colourCompare ~= nil ) then
		local passed = -1;
		if ( currentConstraints.colourCompare[3] == 1 ) then
			if ( numColours["colours"][stringToIndex[currentConstraints.colourCompare[1]]] > numColours["colours"][stringToIndex[currentConstraints.colourCompare[2]]] ) then
				passed = 1;
			end
		elseif ( currentConstraints.colourCompare[3] == 0 ) then
			if ( numColours["colours"][stringToIndex[currentConstraints.colourCompare[1]]] == numColours["colours"][stringToIndex[currentConstraints.colourCompare[2]]] ) then
				passed = 1;
			end
		elseif ( currentConstraints.colourCompare[3] == -1 ) then
			if ( numColours["colours"][stringToIndex[currentConstraints.colourCompare[1]]] < numColours["colours"][stringToIndex[currentConstraints.colourCompare[2]]] ) then
				passed = 1;
			end
		end
		constraints[4] = passed;		
	end
	if ( currentConstraints.typeRow ~= nil ) then
		local numTypeInRow = numColours[currentConstraints.typeRow[2]].types[stringToIndex[currentConstraints.typeRow[1]]];
		constraints[5] = -1;
		if ( currentConstraints.typeRow[3] == 1 and numTypeInRow > 0 ) then
			constraints[5] = 1;
		elseif ( currentConstraints.typeRow[3] == -1 and numTypeInRow == 0 ) then
			constraints[5] = 1;
		end
	end
	if ( currentConstraints.colourRow ~= nil ) then
		local numColourInRow = numColours[currentConstraints.colourRow[2]].colours[stringToIndex[currentConstraints.colourRow[1]]];
		constraints[6] = -1;
		if ( currentConstraints.colourRow[3] == 1 and numColourInRow > 0 ) then
			constraints[6] = 1;
		elseif ( currentConstraints.colourRow[3] == -1 and numColourInRow == 0 ) then
			constraints[6] = 1;
		end
	end
	if ( currentConstraints.typeMiddle ~= nil ) then
		local typeInMiddle = placedFlowers[5].flowerType;
		constraints[7] = -1;
		if ( currentConstraints.typeMiddle[2] == 1 and typeInMiddle == currentConstraints.typeMiddle[1] ) then
			constraints[7] = 1;
		elseif ( currentConstraints.typeMiddle[2] == -1 and typeInMiddle ~= currentConstraints.typeMiddle[1] ) then
			constraints[7] = 1;
		end
	end
	if ( currentConstraints.colourMiddle ~= nil ) then
		local colourInMiddle = placedFlowers[5].colour;
		constraints[8] = -1;
		if ( currentConstraints.colourMiddle[2] == 1 and colourInMiddle == currentConstraints.colourMiddle[1] ) then
			constraints[8] = 1;
		elseif ( currentConstraints.colourMiddle[2] == -1 and colourInMiddle ~= currentConstraints.colourMiddle[1] ) then
			constraints[8] = 1;
		end
	end
	if ( currentConstraints.noTouchType ~= nil ) then
		constraints[9] = 1;
		for i = 1, 9 do
			if ( placedFlowers[i] ~= nil ) then
				if ( placedFlowers[i].flowerType == currentConstraints.noTouchType[1] ) then
					for j,v in pairs(neighbourList[i]) do
						if ( placedFlowers[v] ~= nil and placedFlowers[v].flowerType == currentConstraints.noTouchType[2] ) then	
							constraints[9] = -1;
						end
					end
				elseif ( placedFlowers[i].flowerType == currentConstraints.noTouchType[2] ) then
					for j,v in pairs(neighbourList[i]) do
						if ( placedFlowers[v] ~= nil and placedFlowers[v].flowerType == currentConstraints.noTouchType[1] ) then	
							constraints[9] = -1;
						end
					end
				end
			end
		end
	end
	if ( currentConstraints.noTouchColour ~= nil ) then
		constraints[10] = 1;
		for i = 1, 9 do
			if ( placedFlowers[i] ~= nil ) then
				if ( placedFlowers[i].colour == currentConstraints.noTouchColour[1] ) then
					for j,v in pairs(neighbourList[i]) do
						if ( placedFlowers[v] ~= nil and placedFlowers[v].colour == currentConstraints.noTouchColour[2] ) then	
							constraints[10] = -1;
						end
					end
				elseif ( placedFlowers[i].colour == currentConstraints.noTouchColour[2] ) then
					for j,v in pairs(neighbourList[i]) do
						if ( placedFlowers[v] ~= nil and placedFlowers[v].colour == currentConstraints.noTouchColour[1] ) then	
							constraints[10] = -1;
						end
					end
				end
			end
		end
	end	
	
	-- add ticks/crosses as appropriate
	local passed = true;
	local resultCount = 1;
	for i = 1, 10 do	
		if ( resultCount > 6 ) then
			break;
		end
		results[resultCount]:SetAlpha( 0 );
		if ( constraints[i] == 1 ) then
			results[resultCount]:LoadImage( "tick" );
			results[resultCount]:SetAlpha( 1 );			
			resultCount = resultCount + 1;
		elseif ( constraints[i] == -1 ) then
			results[resultCount]:LoadImage( "cross" );
			results[resultCount]:SetAlpha( 1 );
			resultCount = resultCount + 1;
			passed = false;
		end
	end
	return passed;
end

function spawn_flowers( flowersInfo ) 
	for i,v in pairs(flowersInfo) do
		local flower_spec = get_flower_spec( "bunch_" .. tostring(i) .. tostring( game:Get("mg_flower_activity_num") ), "bunch_" .. tostring( v.flowerType ) .. "_" .. tostring( v.colour ), flowers[i].position, flowers[i].placement_offset, v );
		table.insert( otherStuffToBeExpired, scene:Spawn( flower_spec ) );
		local vase_spec = get_object_spec( "vase_" .. tostring(i) .. tostring( game:Get("mg_flower_activity_num") ), "vase", { x = flowers[i].position.x + vaseOffset.x, y = flowers[i].position.y + vaseOffset.y } );
		table.insert( otherStuffToBeExpired, scene:Spawn( vase_spec ) );		
	end
end

function spawn_ovals( ovalsInfo )
	for i,v in pairs(ovalsInfo) do
		local oval_spec = get_oval_spec( "oval_" .. tostring(v) .. tostring( game:Get("mg_flower_activity_num") ), { x = ovalOffset.x + OvalInfo[v].position.x, y = ovalOffset.y + OvalInfo[v].position.y }, OvalInfo[v].depth, v );
		table.insert( stuffToMove, scene:Spawn( oval_spec ) );
		table.insert( startPositions, { x = ovalOffset.x + OvalInfo[v].position.x, y = ovalOffset.y + OvalInfo[v].position.y } );
		totalFlowers = i;
	end
end

function get_oval_spec( _name, position, depth, _index )
	return
	{
		name = _name;
		halo = "oval";
		gfx = { image = "oval" };		
		
		command = function(actor)
			actor:SetDepthValue( flowerLayer );
			actor:JumpToPoint( position );
			actor:SetPointAtCursor("cursor");
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
	
			font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			actor:SetAlpha( 1 );	
			actor:SetDepthValue( depth );
			actor.occupied = false;
			actor.index = _index;
			
			actor.on_click = function(flo, button)		
				if ( passed_activity == true ) then
					return;
				end
				if ( currentFlower == nil ) then
					if ( actor.occupied == false ) then
						sfx:PlaySFX( "audio/sfx/clicksound_ground_invalid.ogg", false );
						help_panel_say_raw( scene:grabstring( "pickup_flower" ) );	
					else
						sfx:PlaySFX( "audio/sfx/flower_remove.ogg", false );
						actor:SetPointAtCursor("cursor");
						flowersPlaced = flowersPlaced - 1;
						actor.occupied = false;
						actor:LoadImage( "oval" );					
						placedFlowers[_index] = nil;
						--actor:SetTint( { r = 1, g = 1, b = 1, a = 1 } );
						checkBouquet.active = false;
						checkBouquet:SetPointAtCursor("cursor");
						checkBouquet:LoadImage( "checkbouquet" );
					end
				elseif ( actor.occupied == false ) then
					sfx:PlaySFX( "audio/sfx/flower_place.ogg", false );
					actor:SetPointAtCursor("cursor_open_hand");
					flowersPlaced = flowersPlaced + 1;
					actor:LoadImage( currentFlower.image );
					--actor:SetTint( colours[currentFlower.info.colour] );
					placedFlowers[_index] = currentFlower.info;
					actor.occupied = true;
					currentFlower.moving = false;
					set_cursor_normal();
					currentFlower:Expire();
					currentFlower = nil;
					if ( flowersPlaced == totalFlowers ) then
						checkBouquet.active = true;
						checkBouquet:SetPointAtCursor("cursor_glow");
						checkBouquet:LoadImage( "checkBouquet_active" );
					end
				else
					sfx:PlaySFX( "audio/sfx/flower_place.ogg", false );
					actor:SetPointAtCursor("cursor_open_hand");
					actor:LoadImage( currentFlower.image );
					placedFlowers[_index] = currentFlower.info;
					currentFlower.moving = false;
					set_cursor_normal();
					currentFlower:Expire();
					currentFlower = nil;
				end						
			end
			actor.point_at_fn = function(actor, enter)
				if ( enter == true ) then
					if ( currentFlower ~= nil and actor.occupied == false ) then
						actor:LoadImage( "oval_highlight" );
					end
				elseif ( actor.occupied == false ) then
					actor:LoadImage( "oval" );					
				end
			end	
		end
	}
end

click_fallthrough_spec = 
{
	name = "CLICK_FALLTHROUGH";
	halo = "clickFallthrough";
	gfx = { image = _image };		
	
	command = function(actor)
		actor:SetDepthValue( -1 );
		actor:JumpToPoint( position );
		actor:SetPointAtCursor("cursor");
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 30,
			x = -15,
			w = 90,
			h = 25,
			bubble = false,
			outline_size = 0,

		font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw("");
		actor:SetAlpha( 1 );	
		actor:SetDepthValue( 2 );
		
		actor.on_click = function(flo, button)		
			if ( currentFlower ~= nil ) then
				currentFlower:Expire();
				currentFlower = nil;
				sfx:PlaySFX( "audio/sfx/clicksound_ground_invalid.ogg", false );
				set_cursor_normal();
			end
		end
	end
}

function set_cursor_grab()
	scene.CLICK_FALLTHROUGH:SetPointAtCursor("cursor_closed_hand");
	
	-- stuffToMove is the ovals and bouquet
	for i,v in pairs(stuffToMove) do
		--if v.occupied == false then
			v:SetPointAtCursor("cursor_open_hand");
		--else
		--	v:SetPointAtCursor("cursor_closed_hand");
		--end
	end
end

function set_cursor_normal()
	scene.CLICK_FALLTHROUGH:SetPointAtCursor("cursor");
	
	-- stuffToMove is the ovals and bouquet
	for i,v in pairs(stuffToMove) do
		if v.occupied == true then
			v:SetPointAtCursor("cursor_open_hand");
		else
			v:SetPointAtCursor("cursor");
		end
	end
end

function get_object_spec( _name, _image, position )
	return
	{
		name = _name;
		halo = "";
		gfx = { image = _image };		
		
		command = function(actor)
			actor:SetDepthValue( flowerLayer );
			actor:JumpToPoint( position );
			actor:SetPointAtCursor("cursor");
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
	
			font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			actor:SetAlpha( 1 );	
			actor:SetDepthValue( 2 );
		end
	}
end

function get_flower_spec( _name, _image, position, _offset, _info )
	return
	{
		name = _name;
		halo = "flower";
		gfx = { image = _image };
		hotspot = flowerRegOffset;
		
		command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_HALO_NO_SCALE);
			actor:SetDepthValue( flowerLayer );
			actor:JumpToPoint( position );
			actor:SetPointAtCursor("cursor_open_hand");
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
	
			font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			actor:SetAlpha( 1 );
			actor.original_pos = position;
			actor.info = _info;
			--actor:SetTint( colours[_info.colour] );		
			actor:SetScale( flowerScaleInactive );
			
			actor.on_click = function(flo, button)		
				if ( passed_activity == true ) then
					return;
				end
				if ( currentFlower ~= nil ) then
					currentFlower.moving = false;
					set_cursor_normal();
					currentFlower:Expire();
				end				
				local flower = spawn_flower( _info, position, _offset );	
				flower.moving = true;
				set_cursor_grab();
				flower.movingx = -_offset.x;
				flower.movingy = -_offset.y;
				flower:SetAlpha(0.9);
				flower:StartProc(move_item);
			end
			
			actor.point_at_fn = function(actor, enter)
				if ( enter == true ) then
					actor:SetScale(flowerScaleActive);
				else
					actor:SetScale( flowerScaleInactive );
				end
			end	
		end
	}
end	

function spawn_flower( info, position, offset )
	local moving_flower_spec = get_moving_flower_spec( "movingflower" .. tostring(stringToIndex[info.flowerType]) .. tostring( game:Get("mg_flower_activity_num") ) .. tostring( flowerCounts[stringToIndex[info.flowerType]] ),  info.flowerType .. "_" .. info.colour, position, offset, info );
	flowerCounts[stringToIndex[info.flowerType]] = flowerCounts[stringToIndex[info.flowerType]] + 1;
	sfx:PlaySFX( "audio/sfx/flower_pickup.ogg", false );
	return scene:Spawn( moving_flower_spec );
end

function get_moving_flower_spec( _name, _image, position, _offset, _info )
	return
	{
		name = _name;
		halo = "";
		gfx = { image = _image };		
		
		command = function(actor)
			actor:SetDepthValue( flowerLayer );
			actor:JumpToPoint( position );
			actor:SetPointAtCursor("cursor");
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
	
			font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			actor:SetAlpha( 1 );	
			actor.moving = false;
			actor.info = _info;
			actor.copyFlower = false;
			actor.stem = 0;
			actor.offset = _offset;
			actor.image = _image;
			--actor:SetTint( colours[_info.colour] );
		end;
	}
end	

function move_item(actor)	
	currentFlower = actor;
	while actor ~= nil  and actor.moving do
		local cursorPos = scene:GetCursorPos();
		actor:JumpToPoint { x = cursorPos.x + actor.movingx, y = cursorPos.y + actor.movingy };
		delay(1);
	end
end

function spawn_constraints( constraints )
	local constraints_spec = get_constraints_spec( "constraints" .. tostring( game:Get("mg_flower_activity_num") ), constraintsOffset );
	constraintsActor = scene:Spawn( constraints_spec );
	local constraintsString = scene:grabstring( "constraints_string_" .. tostring( game:Get("mg_flower_activity_num") ) );
	constraintsActor:SayRaw( constraintsString );
	currentConstraints = constraints;	
end

function get_constraints_spec( _name, position )
	return
	{
		name = _name;
		halo = "";
		gfx = { image = "" };		
		
		command = function(actor)
			actor:SetDepthValue( 10 );
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:JumpToPoint( position );
			actor:SetPointAtCursor("cursor");
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 380,
				h = 400,
				bubble = false,
				halign = HALIGN.LEFT,
				anchor = ANCHOR.TOP,
				outline_size = 0,
				lineheight = 18,
				fixed = true,
	
			font = "fonts/graphite_std.mvec"; 
				anchor = ANCHOR.TOP
			};
			actor:SayRaw("");
			actor:SetAlpha( 1 );	
		end
	}
end

function spawn_stems(actor)
	for i,v in pairs(items) do
		if i == game:Get("mg_flower_activity_num") then
			spawn_constraints( v.constraints );
			spawn_flowers( v.flowers );
			spawn_ovals( v.ovals );
		end
	end
	-- spawn bouquet
	local bouquet_spec = get_object_spec( "bouquet" .. tostring( game:Get("mg_flower_activity_num") ), "bouquet", bouquetOffset );
	table.insert( stuffToMove, scene:Spawn( bouquet_spec ) );
	table.insert( startPositions, bouquetOffset );
	local checkBouquet_spec = get_checkBouquet_spec( "checkBouquet" .. tostring( game:Get("mg_flower_activity_num") ), checkBouquetOffset );
	checkBouquet = scene:Spawn( checkBouquet_spec );
	for i = 1, 6 do
		local results_spec = get_object_spec( "result" .. tostring(i) .. tostring( game:Get("mg_flower_activity_num") ), "", resultOffsets[i] );
		results[i] = scene:Spawn( results_spec );
	end
	
	for i,v in pairs(stuffToMove) do	
		local pos = startPositions[i];
		v:JumpToPoint( { x = pos.x + 400, y = pos.y } );			
	end
end

function get_checkBouquet_spec( _name, position )
	return
	{
		name = _name;
		halo = "checkbouquet";
		gfx = { image = "checkBouquet" };		
		
		command = function(actor)
			actor:SetDepthValue( 0 );
			actor:JumpToPoint( position );
			actor:SetPointAtCursor("cursor");
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 42,
				x = 10,
				w = 200,
				h = 90,
				bubble = false,
				outline_size = 0,	
				font = "fonts/franklingothic_demicond.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw( scene:grabstring( "checkBouquet" ) );
			actor:SetAlpha( 1 );	
			actor:SetDepthValue( 20 );
			actor.active = false;
			
			actor.on_click = function(flo, button)			
				if ( passed_activity == true or checkBouquet.active == false ) then
					return;
				end
				sfx:PlaySFX("audio/sfx/tutorial_popup");
				if ( CheckConstraints() == true ) then
					passed_activity = true;
					flo:StartProc(activity_passed);
				else
					flo:StartProc(function(flo)
						flo:SetMode(MODE.CUTSCENE);
						coroutine.yield(RESUME.ON_CLICK);
						for i = 1, 6 do	
							results[i]:SetAlpha( 0 );
						end
						flo:SetMode(MODE.FOLLOWCLICKS);
					end);
				end
			end
			
			actor.point_at_fn = function(actor, enter)
				if ( enter == true ) then
					if ( actor.active == true ) then
						actor:LoadImage( "checkBouquet_highlight" );
					end
				else
					if ( actor.active == true ) then
						actor:LoadImage( "checkBouquet_active" );
					else
						actor:LoadImage( "checkBouquet" );
					end
				end
			end
		end
	}
end

function DoTransitionOn()
	local j = 0;
	local speed = 5;
	sfx:PlaySFX("audio/sfx/flower_bouquet_appear")
	while ( j < 400 ) do
		for i,v in pairs(stuffToMove) do	
			local pos = startPositions[i];
			v:JumpToPoint( { x = pos.x + ( 400 - j ), y = pos.y } );			
		end
		j = j + speed;		
		delay(1);
	end	
end

function DoTransitionOff()
	local j = 0;
	local speed = 5;
	while ( j < 100 ) do
		for i,v in pairs(stuffToMove) do	
			local pos = v:GetPosition();
			v:JumpToPoint( { x = pos.x + speed, y = pos.y } );			
		end
		j = j + 1;		
		delay(1);
	end	
end

function setup_activity()
	local activityNum = game:Get("mg_flower_activity_num");
	local activityRound = game:Get("mg_flower_activity_round");
	
	if initial_setup then
		if show_activity_text == true then
			scene:Spawn(activity_title_spec);
			scene:Spawn(round_num_spec);
			scene:Spawn(activity_num_spec);
		end
		coroutine.yield(RESUME.NOW);		
		if activityNum == 1 and activityRound == 1 then
			help_panel_say_raw(scene:grabstring("tutorial_1"));
		end
	else
		help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
		spawn_stems();
	end
	
	if show_activity_text == true then
		scene.ACTIVITY_NUM:SayRaw(scene:grabstring("activity") .. " " .. tostring(activityNum));
		scene.ROUND_NUM:SayRaw(scene:grabstring("round") .. " " .. tostring(activityRound));
	end
	
	DoTransitionOn();
		
	if initial_setup then
		initial_setup = false;
	end
end;

function play_end_particles()
	for i,v in pairs(stuffToMove) do
		v:StartProc(load_party);
	end
	delay(40);
end

function load_party(thing)
	thing:LoadPartyDepth("quest/shared/bead_" .. "green" .. ".lua", 1000);
	thing:SetPartyOffset( { x = 0, y = 50 } );
	delay(40);
	thing:DumpParty();
end

function next_activity(flo)
	local activityNum = game:Get("mg_flower_activity_num");
	local activityRound = game:Get("mg_flower_activity_round");
	local roundComplete = activityNum == 1; -- on next round
	
	if roundComplete then	
		goto_scene(flo, "m3_flowershop");	
	else
		scene.NEXT_ACTIVITY_BUTTON:Expire();
		
		play_end_particles();
		DoTransitionOff();
		
		if IsCheatMode() then
			spawn_button(pass_activity_button_spec);
			--spawn_button(fail_activity_button_spec);
		end
		
		spawn_button(hint_button_spec);
		move_actor_y(scene.HINT_BUTTON, -hud_lower_offset);
		spawn_button(back_button_spec);
		move_actor_y(scene.BACK_BUTTON, -hud_lower_offset);
			
		reset();
		
		-- load new puzzle
		setup_activity();
	end
end;

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	clicksound = "audio/sfx/buttonclick";
	rolloversound = "audio/sfx/button_rollover";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		help_panel_say_raw( scene:grabstring( "hint_" .. tostring( game:Get( "mg_flower_activity_num" ) ) ) );
		flo:StartProc(function(flo)
			flo:SetMode(MODE.CUTSCENE);
			coroutine.yield(RESUME.ON_CLICK);
			help_panel_say_raw(scene:grabstring("help_" .. tostring(game:Get("mg_flower_activity_round")) .. "_" .. tostring(game:Get("mg_flower_activity_num"))));
			flo:SetMode(MODE.FOLLOWCLICKS);
		end);
	end;
}

function activity_passed(flo)
	local activityNum = game:Get("mg_flower_activity_num");
	local activityRound = game:Get("mg_flower_activity_round");
	local roundComplete = activityNum == round_num[activityRound];
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
		--scene.FAIL_ACTIVITY_BUTTON:Expire();
	end
	
	scene.HINT_BUTTON:Expire();
	scene.BACK_BUTTON:Expire();
	spawn_button(next_activity_button_spec);
	scene.NEXT_ACTIVITY_BUTTON:StartProc(pulse_actor);
	
	help_panel_say_raw(
		scene:grabstring("activity_complete_" .. tostring(activityNum)));
	
	if roundComplete then	
		if activityRound == 1 then
			game:Set("mg_flower_activity_round", 2);
			game:Set("mg_flower_activity_num", 1);		
		end
	else
		game:Set("mg_flower_activity_num", activityNum + 1);
	end
	
	-- save progress
	-- we're not saving our progress if the round is complete, as this will take us to an invalid screen
	if activityMode or not roundComplete then
		game:SaveGame();
	end
	
	checkBouquet.active = false;
	checkBouquet:SetPointAtCursor("cursor");
	checkBouquet:LoadImage( "checkBouquet" );
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/flower_bouquet_done");
	coroutine.yield(RESUME.ON_SIGNAL);
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

activity_title_spec = 
{
	name = "ACTIVITY_TITLE";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 10 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 40,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:SayRaw(scene:grabstring("activity_title"));
	end;
};

round_num_spec = 
{
	name = "ROUND_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 60 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

activity_num_spec = 
{
	name = "ACTIVITY_NUM";
	
	command = function(actor)
		actor:JumpToPoint { x = 300, y = 120 };
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 19,
			x = 5,
			w = 250,
			h = 50,
			lineheight = 30,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function go_back(flo)
	kill_help_panel();
	goto_scene(flo, "m3_flowershop");
end;

function reset()
	for i,v in pairs(otherStuffToBeExpired) do	
		v:Expire();
	end
	otherStuffToBeExpired = { };
	for i,v in pairs(stuffToMove) do
		v:Expire();
	end
	stuffToMove = { };
	startPositions = { };
	constraintsActor:Expire();
	for i = 1, 6 do
		results[i]:Expire();
		results[i]:Expire();
	end
	checkBouquet:Expire();
	placedFlowers = { nil, nil, nil, nil, nil, nil, nil, nil, nil };
	results = { nil, nil, nil, nil, nil, nil };
	flowersPlaced = 0;
	totalFlowers = 0;
	currentFlower = nil;
	checkBouquet = nil;
	currentConstraints = nil;
	constraintsActor = nil;
	passed_activity = false;
end

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/beautysalonmusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		game:ClearInvUsage();
		
		fade_scene_up(true);
		
		if IsCheatMode() then
			-- testing data
			spawn_button(pass_activity_button_spec);
			--spawn_button(fail_activity_button_spec);
		end
		
		if game:Get("first_time_flower_activity") < 1 then
			game:Set("first_time_flower_activity", 1);
		end;
		
		-- set up for initial play
		if game:Get("mg_flower_activity_num") < 1 then
			game:Set("mg_flower_activity_num", 1);
		end
		
		if game:Get("mg_flower_activity_round") < 1 then
			game:Set("mg_flower_activity_round", 1);
		end
		
		spawn_stems();
		
		lower_hud();
		spawn_button(hint_button_spec);
		spawn_help_panel();
		
		setup_activity();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
		"bunches"
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		scene_setup,
		click_fallthrough_spec,
	};
};
